<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for verify asset
 */
class Verifyasset extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $Created_on;
    public $transactionid;
    public $reassignerid;
    public $reciverid;
    public $status;
    public $url;
    public $verifyassetid;
    public $asset_id;
    public $MDA_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'verifyasset';
        $this->TableName = 'verify asset';
        $this->TableType = 'VIEW';

        // Update Table
        $this->UpdateTable = "`verify asset`";
        $this->Dbid = 'DB';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // Created_on
        $this->Created_on = new DbField('verifyasset', 'verify asset', 'x_Created_on', 'Created_on', '`Created_on`', CastDateFieldForLike("`Created_on`", 1, "DB"), 135, 19, 1, false, '`Created_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_on->Sortable = true; // Allow sort
        $this->Created_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Created_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_on->Param, "CustomMsg");
        $this->Fields['Created_on'] = &$this->Created_on;

        // transactionid
        $this->transactionid = new DbField('verifyasset', 'verify asset', 'x_transactionid', 'transactionid', '`transactionid`', '`transactionid`', 200, 50, -1, false, '`transactionid`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->transactionid->Nullable = false; // NOT NULL field
        $this->transactionid->Required = true; // Required field
        $this->transactionid->Sortable = true; // Allow sort
        $this->transactionid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->transactionid->Param, "CustomMsg");
        $this->Fields['transactionid'] = &$this->transactionid;

        // reassignerid
        $this->reassignerid = new DbField('verifyasset', 'verify asset', 'x_reassignerid', 'reassignerid', '`reassignerid`', '`reassignerid`', 3, 100, -1, false, '`reassignerid`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->reassignerid->Nullable = false; // NOT NULL field
        $this->reassignerid->Required = true; // Required field
        $this->reassignerid->Sortable = true; // Allow sort
        $this->reassignerid->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->reassignerid->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->reassignerid->Lookup = new Lookup('reassignerid', 'reportuserstbl', false, 'userid', ["Username","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->reassignerid->Lookup = new Lookup('reassignerid', 'reportuserstbl', false, 'userid', ["Username","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->reassignerid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->reassignerid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->reassignerid->Param, "CustomMsg");
        $this->Fields['reassignerid'] = &$this->reassignerid;

        // reciverid
        $this->reciverid = new DbField('verifyasset', 'verify asset', 'x_reciverid', 'reciverid', '`reciverid`', '`reciverid`', 3, 100, -1, false, '`reciverid`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->reciverid->Nullable = false; // NOT NULL field
        $this->reciverid->Required = true; // Required field
        $this->reciverid->Sortable = true; // Allow sort
        $this->reciverid->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->reciverid->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->reciverid->Lookup = new Lookup('reciverid', 'custodianstbl', false, 'id', ["Lastname","Firstname","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->reciverid->Lookup = new Lookup('reciverid', 'custodianstbl', false, 'id', ["Lastname","Firstname","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->reciverid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->reciverid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->reciverid->Param, "CustomMsg");
        $this->Fields['reciverid'] = &$this->reciverid;

        // status
        $this->status = new DbField('verifyasset', 'verify asset', 'x_status', 'status', '`status`', '`status`', 16, 1, -1, false, '`status`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->status->Nullable = false; // NOT NULL field
        $this->status->Required = true; // Required field
        $this->status->Sortable = true; // Allow sort
        $this->status->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->status->Lookup = new Lookup('status', 'verifyasset', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
            default:
                $this->status->Lookup = new Lookup('status', 'verifyasset', false, '', ["","","",""], [], [], [], [], [], [], '', '');
                break;
        }
        $this->status->OptionCount = 2;
        $this->status->DefaultErrorMessage = $Language->phrase("IncorrectField");
        $this->status->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->status->Param, "CustomMsg");
        $this->Fields['status'] = &$this->status;

        // url
        $this->url = new DbField('verifyasset', 'verify asset', 'x_url', 'url', '`url`', '`url`', 200, 255, -1, false, '`url`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->url->Nullable = false; // NOT NULL field
        $this->url->Required = true; // Required field
        $this->url->Sortable = true; // Allow sort
        $this->url->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->url->Param, "CustomMsg");
        $this->Fields['url'] = &$this->url;

        // verifyassetid
        $this->verifyassetid = new DbField('verifyasset', 'verify asset', 'x_verifyassetid', 'verifyassetid', '`verifyassetid`', '`verifyassetid`', 3, 11, -1, false, '`verifyassetid`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->verifyassetid->IsPrimaryKey = true; // Primary key field
        $this->verifyassetid->Nullable = false; // NOT NULL field
        $this->verifyassetid->Sortable = true; // Allow sort
        $this->verifyassetid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->verifyassetid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->verifyassetid->Param, "CustomMsg");
        $this->Fields['verifyassetid'] = &$this->verifyassetid;

        // asset_id
        $this->asset_id = new DbField('verifyasset', 'verify asset', 'x_asset_id', 'asset_id', '`asset_id`', '`asset_id`', 3, 100, -1, false, '`asset_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->asset_id->Nullable = false; // NOT NULL field
        $this->asset_id->Required = true; // Required field
        $this->asset_id->Sortable = true; // Allow sort
        $this->asset_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->asset_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->asset_id->Param, "CustomMsg");
        $this->Fields['asset_id'] = &$this->asset_id;

        // MDA_id
        $this->MDA_id = new DbField('verifyasset', 'verify asset', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 100, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->Fields['MDA_id'] = &$this->MDA_id;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`verify asset`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        global $Security;
        // Add User ID filter
        if ($Security->currentUserID() != "" && !$Security->isAdmin()) { // Non system admin
            $filter = $this->addUserIDFilter($filter);
        }
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('verifyassetid', $rs)) {
                AddFilter($where, QuotedName('verifyassetid', $this->Dbid) . '=' . QuotedValue($rs['verifyassetid'], $this->verifyassetid->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->Created_on->DbValue = $row['Created_on'];
        $this->transactionid->DbValue = $row['transactionid'];
        $this->reassignerid->DbValue = $row['reassignerid'];
        $this->reciverid->DbValue = $row['reciverid'];
        $this->status->DbValue = $row['status'];
        $this->url->DbValue = $row['url'];
        $this->verifyassetid->DbValue = $row['verifyassetid'];
        $this->asset_id->DbValue = $row['asset_id'];
        $this->MDA_id->DbValue = $row['MDA_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`verifyassetid` = @verifyassetid@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->verifyassetid->CurrentValue : $this->verifyassetid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->verifyassetid->CurrentValue = $keys[0];
            } else {
                $this->verifyassetid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('verifyassetid', $row) ? $row['verifyassetid'] : null;
        } else {
            $val = $this->verifyassetid->OldValue !== null ? $this->verifyassetid->OldValue : $this->verifyassetid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@verifyassetid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("verifyassetlist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "verifyassetview") {
            return $Language->phrase("View");
        } elseif ($pageName == "verifyassetedit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "verifyassetadd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "VerifyassetView";
            case Config("API_ADD_ACTION"):
                return "VerifyassetAdd";
            case Config("API_EDIT_ACTION"):
                return "VerifyassetEdit";
            case Config("API_DELETE_ACTION"):
                return "VerifyassetDelete";
            case Config("API_LIST_ACTION"):
                return "VerifyassetList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "verifyassetlist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("verifyassetview", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("verifyassetview", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "verifyassetadd?" . $this->getUrlParm($parm);
        } else {
            $url = "verifyassetadd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("verifyassetedit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("verifyassetadd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("verifyassetdelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "verifyassetid:" . JsonEncode($this->verifyassetid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->verifyassetid->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->verifyassetid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("verifyassetid") ?? Route("verifyassetid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->verifyassetid->CurrentValue = $key;
            } else {
                $this->verifyassetid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->Created_on->setDbValue($row['Created_on']);
        $this->transactionid->setDbValue($row['transactionid']);
        $this->reassignerid->setDbValue($row['reassignerid']);
        $this->reciverid->setDbValue($row['reciverid']);
        $this->status->setDbValue($row['status']);
        $this->url->setDbValue($row['url']);
        $this->verifyassetid->setDbValue($row['verifyassetid']);
        $this->asset_id->setDbValue($row['asset_id']);
        $this->MDA_id->setDbValue($row['MDA_id']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // Created_on

        // transactionid

        // reassignerid

        // reciverid

        // status

        // url

        // verifyassetid

        // asset_id

        // MDA_id

        // Created_on
        $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
        $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 1);
        $this->Created_on->ViewCustomAttributes = "";

        // transactionid
        $this->transactionid->ViewValue = $this->transactionid->CurrentValue;
        $this->transactionid->ViewCustomAttributes = "";

        // reassignerid
        $curVal = trim(strval($this->reassignerid->CurrentValue));
        if ($curVal != "") {
            $this->reassignerid->ViewValue = $this->reassignerid->lookupCacheOption($curVal);
            if ($this->reassignerid->ViewValue === null) { // Lookup from database
                $filterWrk = "`userid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->reassignerid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reassignerid->Lookup->renderViewRow($rswrk[0]);
                    $this->reassignerid->ViewValue = $this->reassignerid->displayValue($arwrk);
                } else {
                    $this->reassignerid->ViewValue = $this->reassignerid->CurrentValue;
                }
            }
        } else {
            $this->reassignerid->ViewValue = null;
        }
        $this->reassignerid->ViewCustomAttributes = "";

        // reciverid
        $curVal = trim(strval($this->reciverid->CurrentValue));
        if ($curVal != "") {
            $this->reciverid->ViewValue = $this->reciverid->lookupCacheOption($curVal);
            if ($this->reciverid->ViewValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->reciverid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reciverid->Lookup->renderViewRow($rswrk[0]);
                    $this->reciverid->ViewValue = $this->reciverid->displayValue($arwrk);
                } else {
                    $this->reciverid->ViewValue = $this->reciverid->CurrentValue;
                }
            }
        } else {
            $this->reciverid->ViewValue = null;
        }
        $this->reciverid->ViewCustomAttributes = "";

        // status
        if (strval($this->status->CurrentValue) != "") {
            $this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
        } else {
            $this->status->ViewValue = null;
        }
        $this->status->ViewCustomAttributes = "";

        // url
        $this->url->ViewValue = $this->url->CurrentValue;
        $this->url->ViewCustomAttributes = "";

        // verifyassetid
        $this->verifyassetid->ViewValue = $this->verifyassetid->CurrentValue;
        $this->verifyassetid->ViewValue = FormatNumber($this->verifyassetid->ViewValue, 0, -2, -2, -2);
        $this->verifyassetid->ViewCustomAttributes = "";

        // asset_id
        $this->asset_id->ViewValue = $this->asset_id->CurrentValue;
        $this->asset_id->ViewValue = FormatNumber($this->asset_id->ViewValue, 0, -2, -2, -2);
        $this->asset_id->ViewCustomAttributes = "";

        // MDA_id
        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
        $this->MDA_id->ViewValue = FormatNumber($this->MDA_id->ViewValue, 0, -2, -2, -2);
        $this->MDA_id->ViewCustomAttributes = "";

        // Created_on
        $this->Created_on->LinkCustomAttributes = "";
        $this->Created_on->HrefValue = "";
        $this->Created_on->TooltipValue = "";

        // transactionid
        $this->transactionid->LinkCustomAttributes = "";
        $this->transactionid->HrefValue = "";
        $this->transactionid->TooltipValue = "";

        // reassignerid
        $this->reassignerid->LinkCustomAttributes = "";
        $this->reassignerid->HrefValue = "";
        $this->reassignerid->TooltipValue = "";

        // reciverid
        $this->reciverid->LinkCustomAttributes = "";
        $this->reciverid->HrefValue = "";
        $this->reciverid->TooltipValue = "";

        // status
        $this->status->LinkCustomAttributes = "";
        $this->status->HrefValue = "";
        $this->status->TooltipValue = "";

        // url
        $this->url->LinkCustomAttributes = "";
        if (!EmptyValue($this->url->CurrentValue)) {
            $this->url->HrefValue = (!empty($this->url->ViewValue) && !is_array($this->url->ViewValue) ? RemoveHtml($this->url->ViewValue) : $this->url->CurrentValue); // Add prefix/suffix
            $this->url->LinkAttrs["target"] = "_blank"; // Add target
            if ($this->isExport()) {
                $this->url->HrefValue = FullUrl($this->url->HrefValue, "href");
            }
        } else {
            $this->url->HrefValue = "";
        }
        $this->url->TooltipValue = "";

        // verifyassetid
        $this->verifyassetid->LinkCustomAttributes = "";
        $this->verifyassetid->HrefValue = "";
        $this->verifyassetid->TooltipValue = "";

        // asset_id
        $this->asset_id->LinkCustomAttributes = "";
        $this->asset_id->HrefValue = "";
        $this->asset_id->TooltipValue = "";

        // MDA_id
        $this->MDA_id->LinkCustomAttributes = "";
        $this->MDA_id->HrefValue = "";
        $this->MDA_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Created_on
        $this->Created_on->EditAttrs["class"] = "form-control";
        $this->Created_on->EditCustomAttributes = "";
        $this->Created_on->EditValue = $this->Created_on->CurrentValue;
        $this->Created_on->EditValue = FormatDateTime($this->Created_on->EditValue, 1);
        $this->Created_on->ViewCustomAttributes = "";

        // transactionid
        $this->transactionid->EditAttrs["class"] = "form-control";
        $this->transactionid->EditCustomAttributes = "";
        $this->transactionid->EditValue = $this->transactionid->CurrentValue;
        $this->transactionid->ViewCustomAttributes = "";

        // reassignerid
        $this->reassignerid->EditAttrs["class"] = "form-control";
        $this->reassignerid->EditCustomAttributes = "";
        $curVal = trim(strval($this->reassignerid->CurrentValue));
        if ($curVal != "") {
            $this->reassignerid->EditValue = $this->reassignerid->lookupCacheOption($curVal);
            if ($this->reassignerid->EditValue === null) { // Lookup from database
                $filterWrk = "`userid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->reassignerid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reassignerid->Lookup->renderViewRow($rswrk[0]);
                    $this->reassignerid->EditValue = $this->reassignerid->displayValue($arwrk);
                } else {
                    $this->reassignerid->EditValue = $this->reassignerid->CurrentValue;
                }
            }
        } else {
            $this->reassignerid->EditValue = null;
        }
        $this->reassignerid->ViewCustomAttributes = "";

        // reciverid
        $this->reciverid->EditAttrs["class"] = "form-control";
        $this->reciverid->EditCustomAttributes = "";
        $curVal = trim(strval($this->reciverid->CurrentValue));
        if ($curVal != "") {
            $this->reciverid->EditValue = $this->reciverid->lookupCacheOption($curVal);
            if ($this->reciverid->EditValue === null) { // Lookup from database
                $filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
                $sqlWrk = $this->reciverid->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                $rswrk = Conn()->executeQuery($sqlWrk)->fetchAll(\PDO::FETCH_BOTH);
                $ari = count($rswrk);
                if ($ari > 0) { // Lookup values found
                    $arwrk = $this->reciverid->Lookup->renderViewRow($rswrk[0]);
                    $this->reciverid->EditValue = $this->reciverid->displayValue($arwrk);
                } else {
                    $this->reciverid->EditValue = $this->reciverid->CurrentValue;
                }
            }
        } else {
            $this->reciverid->EditValue = null;
        }
        $this->reciverid->ViewCustomAttributes = "";

        // status
        $this->status->EditAttrs["class"] = "form-control";
        $this->status->EditCustomAttributes = "";
        $this->status->EditValue = $this->status->options(true);
        $this->status->PlaceHolder = RemoveHtml($this->status->caption());

        // url
        $this->url->EditAttrs["class"] = "form-control";
        $this->url->EditCustomAttributes = "";
        $this->url->EditValue = $this->url->CurrentValue;
        $this->url->ViewCustomAttributes = "";

        // verifyassetid
        $this->verifyassetid->EditAttrs["class"] = "form-control";
        $this->verifyassetid->EditCustomAttributes = "";
        $this->verifyassetid->EditValue = $this->verifyassetid->CurrentValue;
        $this->verifyassetid->PlaceHolder = RemoveHtml($this->verifyassetid->caption());

        // asset_id
        $this->asset_id->EditAttrs["class"] = "form-control";
        $this->asset_id->EditCustomAttributes = "";
        $this->asset_id->EditValue = $this->asset_id->CurrentValue;
        $this->asset_id->PlaceHolder = RemoveHtml($this->asset_id->caption());

        // MDA_id
        $this->MDA_id->EditAttrs["class"] = "form-control";
        $this->MDA_id->EditCustomAttributes = "";
        if (!$Security->isAdmin() && $Security->isLoggedIn() && !$this->userIDAllow("info")) { // Non system admin
            $this->MDA_id->CurrentValue = CurrentUserID();
            $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
            $this->MDA_id->EditValue = FormatNumber($this->MDA_id->EditValue, 0, -2, -2, -2);
            $this->MDA_id->ViewCustomAttributes = "";
        } else {
            $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
            $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());
        }

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->transactionid);
                    $doc->exportCaption($this->reassignerid);
                    $doc->exportCaption($this->reciverid);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->url);
                    $doc->exportCaption($this->verifyassetid);
                    $doc->exportCaption($this->asset_id);
                    $doc->exportCaption($this->MDA_id);
                } else {
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->transactionid);
                    $doc->exportCaption($this->reassignerid);
                    $doc->exportCaption($this->reciverid);
                    $doc->exportCaption($this->status);
                    $doc->exportCaption($this->url);
                    $doc->exportCaption($this->asset_id);
                    $doc->exportCaption($this->MDA_id);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->transactionid);
                        $doc->exportField($this->reassignerid);
                        $doc->exportField($this->reciverid);
                        $doc->exportField($this->status);
                        $doc->exportField($this->url);
                        $doc->exportField($this->verifyassetid);
                        $doc->exportField($this->asset_id);
                        $doc->exportField($this->MDA_id);
                    } else {
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->transactionid);
                        $doc->exportField($this->reassignerid);
                        $doc->exportField($this->reciverid);
                        $doc->exportField($this->status);
                        $doc->exportField($this->url);
                        $doc->exportField($this->asset_id);
                        $doc->exportField($this->MDA_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Add User ID filter
    public function addUserIDFilter($filter = "")
    {
        global $Security;
        $filterWrk = "";
        $id = (CurrentPageID() == "list") ? $this->CurrentAction : CurrentPageID();
        if (!$this->userIDAllow($id) && !$Security->isAdmin()) {
            $filterWrk = $Security->userIdList();
            if ($filterWrk != "") {
                $filterWrk = '`MDA_id` IN (' . $filterWrk . ')';
            }
        }

        // Call User ID Filtering event
        $this->userIdFiltering($filterWrk);
        AddFilter($filter, $filterWrk);
        return $filter;
    }

    // User ID subquery
    public function getUserIDSubquery(&$fld, &$masterfld)
    {
        global $UserTable;
        $wrk = "";
        $sql = "SELECT " . $masterfld->Expression . " FROM `verify asset`";
        $filter = $this->addUserIDFilter("");
        if ($filter != "") {
            $sql .= " WHERE " . $filter;
        }

        // List all values
        if ($rs = Conn($UserTable->Dbid)->executeQuery($sql)->fetchAll(\PDO::FETCH_NUM)) {
            foreach ($rs as $row) {
                if ($wrk != "") {
                    $wrk .= ",";
                }
                $wrk .= QuotedValue($row[0], $masterfld->DataType, Config("USER_TABLE_DBID"));
            }
        }
        if ($wrk != "") {
            $wrk = $fld->Expression . " IN (" . $wrk . ")";
        } else { // No User ID value found
            $wrk = "0=1";
        }
        return $wrk;
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Table level events
    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
    // Get cus

    /*
        $username= CurrentUsername();
        $myRow = ExecuteRow("SELECT userid FROM reportuserstbl WHERE Username  = '$username'");
         $userid = $myRow["userid"];
    $myuserlevel=CurrentUserLevel();
        // Enter your code here
         AddFilter($filter, "reassignerid = '". $userid."' ");
     */       
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
