<?php

namespace PHPMaker2021\EkitiAssetsVintoICT;

use Doctrine\DBAL\ParameterType;

/**
 * Table class for directorytbl
 */
class Directorytbl extends DbTable
{
    protected $SqlFrom = "";
    protected $SqlSelect = null;
    protected $SqlSelectList = null;
    protected $SqlWhere = "";
    protected $SqlGroupBy = "";
    protected $SqlHaving = "";
    protected $SqlOrderBy = "";
    public $UseSessionForListSql = true;

    // Column CSS classes
    public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
    public $RightColumnClass = "col-sm-10";
    public $OffsetColumnClass = "col-sm-10 offset-sm-2";
    public $TableLeftColumnClass = "w-col-2";

    // Export
    public $ExportDoc;

    // Fields
    public $Directoryid;
    public $Firstname;
    public $Middlename;
    public $Lastname;
    public $_Email;
    public $Phone;
    public $Created_on;
    public $Updated_on;
    public $MDA_id;
    public $Cadre_id;
    public $MDA_temp;
    public $Asset_User_id;

    // Page ID
    public $PageID = ""; // To be overridden by subclass

    // Constructor
    public function __construct()
    {
        global $Language, $CurrentLanguage;
        parent::__construct();

        // Language object
        $Language = Container("language");
        $this->TableVar = 'directorytbl';
        $this->TableName = 'directorytbl';
        $this->TableType = 'LINKTABLE';

        // Update Table
        $this->UpdateTable = "`directorytbl`";
        $this->Dbid = 'ekdirectory';
        $this->ExportAll = true;
        $this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
        $this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
        $this->ExportPageSize = "a4"; // Page size (PDF only)
        $this->ExportExcelPageOrientation = ""; // Page orientation (PhpSpreadsheet only)
        $this->ExportExcelPageSize = ""; // Page size (PhpSpreadsheet only)
        $this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
        $this->ExportWordColumnWidth = null; // Cell width (PHPWord only)
        $this->DetailAdd = false; // Allow detail add
        $this->DetailEdit = false; // Allow detail edit
        $this->DetailView = false; // Allow detail view
        $this->ShowMultipleDetails = false; // Show multiple details
        $this->GridAddRowCount = 5;
        $this->AllowAddDeleteRow = true; // Allow add/delete row
        $this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
        $this->BasicSearch = new BasicSearch($this->TableVar);

        // Directoryid
        $this->Directoryid = new DbField('directorytbl', 'directorytbl', 'x_Directoryid', 'Directoryid', '`Directoryid`', '`Directoryid`', 3, 11, -1, false, '`Directoryid`', false, false, false, 'FORMATTED TEXT', 'NO');
        $this->Directoryid->IsAutoIncrement = true; // Autoincrement field
        $this->Directoryid->IsPrimaryKey = true; // Primary key field
        $this->Directoryid->Sortable = true; // Allow sort
        $this->Directoryid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Directoryid->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Directoryid->Param, "CustomMsg");
        $this->Fields['Directoryid'] = &$this->Directoryid;

        // Firstname
        $this->Firstname = new DbField('directorytbl', 'directorytbl', 'x_Firstname', 'Firstname', '`Firstname`', '`Firstname`', 200, 50, -1, false, '`Firstname`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Firstname->Nullable = false; // NOT NULL field
        $this->Firstname->Required = true; // Required field
        $this->Firstname->Sortable = true; // Allow sort
        $this->Firstname->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Firstname->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Firstname->Param, "CustomMsg");
        $this->Fields['Firstname'] = &$this->Firstname;

        // Middlename
        $this->Middlename = new DbField('directorytbl', 'directorytbl', 'x_Middlename', 'Middlename', '`Middlename`', '`Middlename`', 200, 50, -1, false, '`Middlename`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Middlename->Required = true; // Required field
        $this->Middlename->Sortable = true; // Allow sort
        $this->Middlename->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Middlename->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Middlename->Param, "CustomMsg");
        $this->Fields['Middlename'] = &$this->Middlename;

        // Lastname
        $this->Lastname = new DbField('directorytbl', 'directorytbl', 'x_Lastname', 'Lastname', '`Lastname`', '`Lastname`', 200, 50, -1, false, '`Lastname`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Lastname->Nullable = false; // NOT NULL field
        $this->Lastname->Required = true; // Required field
        $this->Lastname->Sortable = true; // Allow sort
        $this->Lastname->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Lastname->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Lastname->Param, "CustomMsg");
        $this->Fields['Lastname'] = &$this->Lastname;

        // Email
        $this->_Email = new DbField('directorytbl', 'directorytbl', 'x__Email', 'Email', '`Email`', '`Email`', 200, 100, -1, false, '`Email`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->_Email->Sortable = true; // Allow sort
        $this->_Email->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->_Email->Param, "CustomMsg");
        $this->Fields['Email'] = &$this->_Email;

        // Phone
        $this->Phone = new DbField('directorytbl', 'directorytbl', 'x_Phone', 'Phone', '`Phone`', '`Phone`', 200, 11, -1, false, '`Phone`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Phone->Nullable = false; // NOT NULL field
        $this->Phone->Required = true; // Required field
        $this->Phone->Sortable = true; // Allow sort
        $this->Phone->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Phone->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Phone->Param, "CustomMsg");
        $this->Fields['Phone'] = &$this->Phone;

        // Created_on
        $this->Created_on = new DbField('directorytbl', 'directorytbl', 'x_Created_on', 'Created_on', '`Created_on`', CastDateFieldForLike("`Created_on`", 0, "ekdirectory"), 133, 10, 0, false, '`Created_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Created_on->Nullable = false; // NOT NULL field
        $this->Created_on->Required = true; // Required field
        $this->Created_on->Sortable = true; // Allow sort
        $this->Created_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Created_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Created_on->Param, "CustomMsg");
        $this->Fields['Created_on'] = &$this->Created_on;

        // Updated_on
        $this->Updated_on = new DbField('directorytbl', 'directorytbl', 'x_Updated_on', 'Updated_on', '`Updated_on`', CastDateFieldForLike("`Updated_on`", 0, "ekdirectory"), 133, 10, 0, false, '`Updated_on`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Updated_on->Nullable = false; // NOT NULL field
        $this->Updated_on->Required = true; // Required field
        $this->Updated_on->Sortable = true; // Allow sort
        $this->Updated_on->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
        $this->Updated_on->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Updated_on->Param, "CustomMsg");
        $this->Fields['Updated_on'] = &$this->Updated_on;

        // MDA_id
        $this->MDA_id = new DbField('directorytbl', 'directorytbl', 'x_MDA_id', 'MDA_id', '`MDA_id`', '`MDA_id`', 3, 11, -1, false, '`MDA_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->MDA_id->Nullable = false; // NOT NULL field
        $this->MDA_id->Required = true; // Required field
        $this->MDA_id->Sortable = true; // Allow sort
        $this->MDA_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->MDA_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_id->Param, "CustomMsg");
        $this->Fields['MDA_id'] = &$this->MDA_id;

        // Cadre_id
        $this->Cadre_id = new DbField('directorytbl', 'directorytbl', 'x_Cadre_id', 'Cadre_id', '`Cadre_id`', '`Cadre_id`', 3, 11, -1, false, '`Cadre_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Cadre_id->Nullable = false; // NOT NULL field
        $this->Cadre_id->Required = true; // Required field
        $this->Cadre_id->Sortable = true; // Allow sort
        $this->Cadre_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Cadre_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Cadre_id->Param, "CustomMsg");
        $this->Fields['Cadre_id'] = &$this->Cadre_id;

        // MDA_temp
        $this->MDA_temp = new DbField('directorytbl', 'directorytbl', 'x_MDA_temp', 'MDA_temp', '`MDA_temp`', '`MDA_temp`', 200, 100, -1, false, '`MDA_temp`', false, false, false, 'FORMATTED TEXT', 'SELECT');
        $this->MDA_temp->Sortable = true; // Allow sort
        $this->MDA_temp->UsePleaseSelect = true; // Use PleaseSelect by default
        $this->MDA_temp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
        switch ($CurrentLanguage) {
            case "en":
                $this->MDA_temp->Lookup = new Lookup('MDA_temp', 'directorytbl', true, 'MDA_temp', ["MDA_temp","","",""], [], [], [], [], [], [], '`MDA_temp`', '');
                break;
            default:
                $this->MDA_temp->Lookup = new Lookup('MDA_temp', 'directorytbl', true, 'MDA_temp', ["MDA_temp","","",""], [], [], [], [], [], [], '`MDA_temp`', '');
                break;
        }
        $this->MDA_temp->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->MDA_temp->Param, "CustomMsg");
        $this->Fields['MDA_temp'] = &$this->MDA_temp;

        // Asset_User_id
        $this->Asset_User_id = new DbField('directorytbl', 'directorytbl', 'x_Asset_User_id', 'Asset_User_id', '`Asset_User_id`', '`Asset_User_id`', 3, 11, -1, false, '`Asset_User_id`', false, false, false, 'FORMATTED TEXT', 'TEXT');
        $this->Asset_User_id->Nullable = false; // NOT NULL field
        $this->Asset_User_id->Required = true; // Required field
        $this->Asset_User_id->Sortable = true; // Allow sort
        $this->Asset_User_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
        $this->Asset_User_id->CustomMsg = $Language->FieldPhrase($this->TableVar, $this->Asset_User_id->Param, "CustomMsg");
        $this->Fields['Asset_User_id'] = &$this->Asset_User_id;
    }

    // Field Visibility
    public function getFieldVisibility($fldParm)
    {
        global $Security;
        return $this->$fldParm->Visible; // Returns original value
    }

    // Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
    public function setLeftColumnClass($class)
    {
        if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
            $this->LeftColumnClass = $class . " col-form-label ew-label";
            $this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
            $this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
            $this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
        }
    }

    // Single column sort
    public function updateSort(&$fld)
    {
        if ($this->CurrentOrder == $fld->Name) {
            $sortField = $fld->Expression;
            $lastSort = $fld->getSort();
            if (in_array($this->CurrentOrderType, ["ASC", "DESC", "NO"])) {
                $curSort = $this->CurrentOrderType;
            } else {
                $curSort = $lastSort;
            }
            $fld->setSort($curSort);
            $orderBy = in_array($curSort, ["ASC", "DESC"]) ? $sortField . " " . $curSort : "";
            $this->setSessionOrderBy($orderBy); // Save to Session
        } else {
            $fld->setSort("");
        }
    }

    // Table level SQL
    public function getSqlFrom() // From
    {
        return ($this->SqlFrom != "") ? $this->SqlFrom : "`directorytbl`";
    }

    public function sqlFrom() // For backward compatibility
    {
        return $this->getSqlFrom();
    }

    public function setSqlFrom($v)
    {
        $this->SqlFrom = $v;
    }

    public function getSqlSelect() // Select
    {
        return $this->SqlSelect ?? $this->getQueryBuilder()->select("*");
    }

    public function sqlSelect() // For backward compatibility
    {
        return $this->getSqlSelect();
    }

    public function setSqlSelect($v)
    {
        $this->SqlSelect = $v;
    }

    public function getSqlWhere() // Where
    {
        $where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
        $this->DefaultFilter = "";
        AddFilter($where, $this->DefaultFilter);
        return $where;
    }

    public function sqlWhere() // For backward compatibility
    {
        return $this->getSqlWhere();
    }

    public function setSqlWhere($v)
    {
        $this->SqlWhere = $v;
    }

    public function getSqlGroupBy() // Group By
    {
        return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
    }

    public function sqlGroupBy() // For backward compatibility
    {
        return $this->getSqlGroupBy();
    }

    public function setSqlGroupBy($v)
    {
        $this->SqlGroupBy = $v;
    }

    public function getSqlHaving() // Having
    {
        return ($this->SqlHaving != "") ? $this->SqlHaving : "";
    }

    public function sqlHaving() // For backward compatibility
    {
        return $this->getSqlHaving();
    }

    public function setSqlHaving($v)
    {
        $this->SqlHaving = $v;
    }

    public function getSqlOrderBy() // Order By
    {
        return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : $this->DefaultSort;
    }

    public function sqlOrderBy() // For backward compatibility
    {
        return $this->getSqlOrderBy();
    }

    public function setSqlOrderBy($v)
    {
        $this->SqlOrderBy = $v;
    }

    // Apply User ID filters
    public function applyUserIDFilters($filter)
    {
        return $filter;
    }

    // Check if User ID security allows view all
    public function userIDAllow($id = "")
    {
        $allow = $this->UserIDAllowSecurity;
        switch ($id) {
            case "add":
            case "copy":
            case "gridadd":
            case "register":
            case "addopt":
                return (($allow & 1) == 1);
            case "edit":
            case "gridedit":
            case "update":
            case "changepassword":
            case "resetpassword":
                return (($allow & 4) == 4);
            case "delete":
                return (($allow & 2) == 2);
            case "view":
                return (($allow & 32) == 32);
            case "search":
                return (($allow & 64) == 64);
            default:
                return (($allow & 8) == 8);
        }
    }

    /**
     * Get record count
     *
     * @param string|QueryBuilder $sql SQL or QueryBuilder
     * @param mixed $c Connection
     * @return int
     */
    public function getRecordCount($sql, $c = null)
    {
        $cnt = -1;
        $rs = null;
        if ($sql instanceof \Doctrine\DBAL\Query\QueryBuilder) { // Query builder
            $sqlwrk = clone $sql;
            $sqlwrk = $sqlwrk->resetQueryPart("orderBy")->getSQL();
        } else {
            $sqlwrk = $sql;
        }
        $pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';
        // Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
        if (
            ($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
            preg_match($pattern, $sqlwrk) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sqlwrk) &&
            !preg_match('/^\s*select\s+distinct\s+/i', $sqlwrk) && !preg_match('/\s+order\s+by\s+/i', $sqlwrk)
        ) {
            $sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sqlwrk);
        } else {
            $sqlwrk = "SELECT COUNT(*) FROM (" . $sqlwrk . ") COUNT_TABLE";
        }
        $conn = $c ?? $this->getConnection();
        $rs = $conn->executeQuery($sqlwrk);
        $cnt = $rs->fetchColumn();
        if ($cnt !== false) {
            return (int)$cnt;
        }

        // Unable to get count by SELECT COUNT(*), execute the SQL to get record count directly
        return ExecuteRecordCount($sql, $conn);
    }

    // Get SQL
    public function getSql($where, $orderBy = "")
    {
        return $this->buildSelectSql(
            $this->getSqlSelect(),
            $this->getSqlFrom(),
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $where,
            $orderBy
        )->getSQL();
    }

    // Table SQL
    public function getCurrentSql()
    {
        $filter = $this->CurrentFilter;
        $filter = $this->applyUserIDFilters($filter);
        $sort = $this->getSessionOrderBy();
        return $this->getSql($filter, $sort);
    }

    /**
     * Table SQL with List page filter
     *
     * @return QueryBuilder
     */
    public function getListSql()
    {
        $filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->getSqlSelect();
        $from = $this->getSqlFrom();
        $sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
        $this->Sort = $sort;
        return $this->buildSelectSql(
            $select,
            $from,
            $this->getSqlWhere(),
            $this->getSqlGroupBy(),
            $this->getSqlHaving(),
            $this->getSqlOrderBy(),
            $filter,
            $sort
        );
    }

    // Get ORDER BY clause
    public function getOrderBy()
    {
        $orderBy = $this->getSqlOrderBy();
        $sort = $this->getSessionOrderBy();
        if ($orderBy != "" && $sort != "") {
            $orderBy .= ", " . $sort;
        } elseif ($sort != "") {
            $orderBy = $sort;
        }
        return $orderBy;
    }

    // Get record count based on filter (for detail record count in master table pages)
    public function loadRecordCount($filter)
    {
        $origFilter = $this->CurrentFilter;
        $this->CurrentFilter = $filter;
        $this->recordsetSelecting($this->CurrentFilter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
        $cnt = $this->getRecordCount($sql);
        $this->CurrentFilter = $origFilter;
        return $cnt;
    }

    // Get record count (for current List page)
    public function listRecordCount()
    {
        $filter = $this->getSessionWhere();
        AddFilter($filter, $this->CurrentFilter);
        $filter = $this->applyUserIDFilters($filter);
        $this->recordsetSelecting($filter);
        $select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : $this->getQueryBuilder()->select("*");
        $groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
        $having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
        $sql = $this->buildSelectSql($select, $this->getSqlFrom(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
        $cnt = $this->getRecordCount($sql);
        return $cnt;
    }

    /**
     * INSERT statement
     *
     * @param mixed $rs
     * @return QueryBuilder
     */
    protected function insertSql(&$rs)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->insert($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->setValue($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        return $queryBuilder;
    }

    // Insert
    public function insert(&$rs)
    {
        $conn = $this->getConnection();
        $success = $this->insertSql($rs)->execute();
        if ($success) {
            // Get insert id if necessary
            $this->Directoryid->setDbValue($conn->lastInsertId());
            $rs['Directoryid'] = $this->Directoryid->DbValue;
        }
        return $success;
    }

    /**
     * UPDATE statement
     *
     * @param array $rs Data to be updated
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function updateSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->update($this->UpdateTable);
        foreach ($rs as $name => $value) {
            if (!isset($this->Fields[$name]) || $this->Fields[$name]->IsCustom || $this->Fields[$name]->IsAutoIncrement) {
                continue;
            }
            $type = GetParameterType($this->Fields[$name], $value, $this->Dbid);
            $queryBuilder->set($this->Fields[$name]->Expression, $queryBuilder->createPositionalParameter($value, $type));
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        AddFilter($filter, $where);
        if ($filter != "") {
            $queryBuilder->where($filter);
        }
        return $queryBuilder;
    }

    // Update
    public function update(&$rs, $where = "", $rsold = null, $curfilter = true)
    {
        // If no field is updated, execute may return 0. Treat as success
        $success = $this->updateSql($rs, $where, $curfilter)->execute();
        $success = ($success > 0) ? $success : true;
        return $success;
    }

    /**
     * DELETE statement
     *
     * @param array $rs Key values
     * @param string|array $where WHERE clause
     * @param string $curfilter Filter
     * @return QueryBuilder
     */
    protected function deleteSql(&$rs, $where = "", $curfilter = true)
    {
        $queryBuilder = $this->getQueryBuilder();
        $queryBuilder->delete($this->UpdateTable);
        if (is_array($where)) {
            $where = $this->arrayToFilter($where);
        }
        if ($rs) {
            if (array_key_exists('Directoryid', $rs)) {
                AddFilter($where, QuotedName('Directoryid', $this->Dbid) . '=' . QuotedValue($rs['Directoryid'], $this->Directoryid->DataType, $this->Dbid));
            }
        }
        $filter = ($curfilter) ? $this->CurrentFilter : "";
        AddFilter($filter, $where);
        return $queryBuilder->where($filter != "" ? $filter : "0=1");
    }

    // Delete
    public function delete(&$rs, $where = "", $curfilter = false)
    {
        $success = true;
        if ($success) {
            $success = $this->deleteSql($rs, $where, $curfilter)->execute();
        }
        return $success;
    }

    // Load DbValue from recordset or array
    protected function loadDbValues($row)
    {
        if (!is_array($row)) {
            return;
        }
        $this->Directoryid->DbValue = $row['Directoryid'];
        $this->Firstname->DbValue = $row['Firstname'];
        $this->Middlename->DbValue = $row['Middlename'];
        $this->Lastname->DbValue = $row['Lastname'];
        $this->_Email->DbValue = $row['Email'];
        $this->Phone->DbValue = $row['Phone'];
        $this->Created_on->DbValue = $row['Created_on'];
        $this->Updated_on->DbValue = $row['Updated_on'];
        $this->MDA_id->DbValue = $row['MDA_id'];
        $this->Cadre_id->DbValue = $row['Cadre_id'];
        $this->MDA_temp->DbValue = $row['MDA_temp'];
        $this->Asset_User_id->DbValue = $row['Asset_User_id'];
    }

    // Delete uploaded files
    public function deleteUploadedFiles($row)
    {
        $this->loadDbValues($row);
    }

    // Record filter WHERE clause
    protected function sqlKeyFilter()
    {
        return "`Directoryid` = @Directoryid@";
    }

    // Get Key
    public function getKey($current = false)
    {
        $keys = [];
        $val = $current ? $this->Directoryid->CurrentValue : $this->Directoryid->OldValue;
        if (EmptyValue($val)) {
            return "";
        } else {
            $keys[] = $val;
        }
        return implode(Config("COMPOSITE_KEY_SEPARATOR"), $keys);
    }

    // Set Key
    public function setKey($key, $current = false)
    {
        $this->OldKey = strval($key);
        $keys = explode(Config("COMPOSITE_KEY_SEPARATOR"), $this->OldKey);
        if (count($keys) == 1) {
            if ($current) {
                $this->Directoryid->CurrentValue = $keys[0];
            } else {
                $this->Directoryid->OldValue = $keys[0];
            }
        }
    }

    // Get record filter
    public function getRecordFilter($row = null)
    {
        $keyFilter = $this->sqlKeyFilter();
        if (is_array($row)) {
            $val = array_key_exists('Directoryid', $row) ? $row['Directoryid'] : null;
        } else {
            $val = $this->Directoryid->OldValue !== null ? $this->Directoryid->OldValue : $this->Directoryid->CurrentValue;
        }
        if (!is_numeric($val)) {
            return "0=1"; // Invalid key
        }
        if ($val === null) {
            return "0=1"; // Invalid key
        } else {
            $keyFilter = str_replace("@Directoryid@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
        }
        return $keyFilter;
    }

    // Return page URL
    public function getReturnUrl()
    {
        $referUrl = ReferUrl();
        $referPageName = ReferPageName();
        $name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");
        // Get referer URL automatically
        if ($referUrl != "" && $referPageName != CurrentPageName() && $referPageName != "login") { // Referer not same page or login page
            $_SESSION[$name] = $referUrl; // Save to Session
        }
        return $_SESSION[$name] ?? GetUrl("directorytbllist");
    }

    // Set return page URL
    public function setReturnUrl($v)
    {
        $_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
    }

    // Get modal caption
    public function getModalCaption($pageName)
    {
        global $Language;
        if ($pageName == "directorytblview") {
            return $Language->phrase("View");
        } elseif ($pageName == "directorytbledit") {
            return $Language->phrase("Edit");
        } elseif ($pageName == "directorytbladd") {
            return $Language->phrase("Add");
        } else {
            return "";
        }
    }

    // API page name
    public function getApiPageName($action)
    {
        switch (strtolower($action)) {
            case Config("API_VIEW_ACTION"):
                return "DirectorytblView";
            case Config("API_ADD_ACTION"):
                return "DirectorytblAdd";
            case Config("API_EDIT_ACTION"):
                return "DirectorytblEdit";
            case Config("API_DELETE_ACTION"):
                return "DirectorytblDelete";
            case Config("API_LIST_ACTION"):
                return "DirectorytblList";
            default:
                return "";
        }
    }

    // List URL
    public function getListUrl()
    {
        return "directorytbllist";
    }

    // View URL
    public function getViewUrl($parm = "")
    {
        if ($parm != "") {
            $url = $this->keyUrl("directorytblview", $this->getUrlParm($parm));
        } else {
            $url = $this->keyUrl("directorytblview", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
        }
        return $this->addMasterUrl($url);
    }

    // Add URL
    public function getAddUrl($parm = "")
    {
        if ($parm != "") {
            $url = "directorytbladd?" . $this->getUrlParm($parm);
        } else {
            $url = "directorytbladd";
        }
        return $this->addMasterUrl($url);
    }

    // Edit URL
    public function getEditUrl($parm = "")
    {
        $url = $this->keyUrl("directorytbledit", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline edit URL
    public function getInlineEditUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
        return $this->addMasterUrl($url);
    }

    // Copy URL
    public function getCopyUrl($parm = "")
    {
        $url = $this->keyUrl("directorytbladd", $this->getUrlParm($parm));
        return $this->addMasterUrl($url);
    }

    // Inline copy URL
    public function getInlineCopyUrl()
    {
        $url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
        return $this->addMasterUrl($url);
    }

    // Delete URL
    public function getDeleteUrl()
    {
        return $this->keyUrl("directorytbldelete", $this->getUrlParm());
    }

    // Add master url
    public function addMasterUrl($url)
    {
        return $url;
    }

    public function keyToJson($htmlEncode = false)
    {
        $json = "";
        $json .= "Directoryid:" . JsonEncode($this->Directoryid->CurrentValue, "number");
        $json = "{" . $json . "}";
        if ($htmlEncode) {
            $json = HtmlEncode($json);
        }
        return $json;
    }

    // Add key value to URL
    public function keyUrl($url, $parm = "")
    {
        if ($this->Directoryid->CurrentValue !== null) {
            $url .= "/" . rawurlencode($this->Directoryid->CurrentValue);
        } else {
            return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
        }
        if ($parm != "") {
            $url .= "?" . $parm;
        }
        return $url;
    }

    // Render sort
    public function renderSort($fld)
    {
        $classId = $fld->TableVar . "_" . $fld->Param;
        $scriptId = str_replace("%id%", $classId, "tpc_%id%");
        $scriptStart = $this->UseCustomTemplate ? "<template id=\"" . $scriptId . "\">" : "";
        $scriptEnd = $this->UseCustomTemplate ? "</template>" : "";
        $jsSort = " class=\"ew-pointer\" onclick=\"ew.sort(event, '" . $this->sortUrl($fld) . "', 1);\"";
        if ($this->sortUrl($fld) == "") {
            $html = <<<NOSORTHTML
{$scriptStart}<div class="ew-table-header-caption">{$fld->caption()}</div>{$scriptEnd}
NOSORTHTML;
        } else {
            if ($fld->getSort() == "ASC") {
                $sortIcon = '<i class="fas fa-sort-up"></i>';
            } elseif ($fld->getSort() == "DESC") {
                $sortIcon = '<i class="fas fa-sort-down"></i>';
            } else {
                $sortIcon = '';
            }
            $html = <<<SORTHTML
{$scriptStart}<div{$jsSort}><div class="ew-table-header-btn"><span class="ew-table-header-caption">{$fld->caption()}</span><span class="ew-table-header-sort">{$sortIcon}</span></div></div>{$scriptEnd}
SORTHTML;
        }
        return $html;
    }

    // Sort URL
    public function sortUrl($fld)
    {
        if (
            $this->CurrentAction || $this->isExport() ||
            in_array($fld->Type, [128, 204, 205])
        ) { // Unsortable data type
                return "";
        } elseif ($fld->Sortable) {
            $urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->getNextSort());
            return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
        } else {
            return "";
        }
    }

    // Get record keys from Post/Get/Session
    public function getRecordKeys()
    {
        $arKeys = [];
        $arKey = [];
        if (Param("key_m") !== null) {
            $arKeys = Param("key_m");
            $cnt = count($arKeys);
        } else {
            if (($keyValue = Param("Directoryid") ?? Route("Directoryid")) !== null) {
                $arKeys[] = $keyValue;
            } elseif (IsApi() && (($keyValue = Key(0) ?? Route(2)) !== null)) {
                $arKeys[] = $keyValue;
            } else {
                $arKeys = null; // Do not setup
            }

            //return $arKeys; // Do not return yet, so the values will also be checked by the following code
        }
        // Check keys
        $ar = [];
        if (is_array($arKeys)) {
            foreach ($arKeys as $key) {
                if (!is_numeric($key)) {
                    continue;
                }
                $ar[] = $key;
            }
        }
        return $ar;
    }

    // Get filter from record keys
    public function getFilterFromRecordKeys($setCurrent = true)
    {
        $arKeys = $this->getRecordKeys();
        $keyFilter = "";
        foreach ($arKeys as $key) {
            if ($keyFilter != "") {
                $keyFilter .= " OR ";
            }
            if ($setCurrent) {
                $this->Directoryid->CurrentValue = $key;
            } else {
                $this->Directoryid->OldValue = $key;
            }
            $keyFilter .= "(" . $this->getRecordFilter() . ")";
        }
        return $keyFilter;
    }

    // Load recordset based on filter
    public function &loadRs($filter)
    {
        $sql = $this->getSql($filter); // Set up filter (WHERE Clause)
        $conn = $this->getConnection();
        $stmt = $conn->executeQuery($sql);
        return $stmt;
    }

    // Load row values from record
    public function loadListRowValues(&$rs)
    {
        if (is_array($rs)) {
            $row = $rs;
        } elseif ($rs && property_exists($rs, "fields")) { // Recordset
            $row = $rs->fields;
        } else {
            return;
        }
        $this->Directoryid->setDbValue($row['Directoryid']);
        $this->Firstname->setDbValue($row['Firstname']);
        $this->Middlename->setDbValue($row['Middlename']);
        $this->Lastname->setDbValue($row['Lastname']);
        $this->_Email->setDbValue($row['Email']);
        $this->Phone->setDbValue($row['Phone']);
        $this->Created_on->setDbValue($row['Created_on']);
        $this->Updated_on->setDbValue($row['Updated_on']);
        $this->MDA_id->setDbValue($row['MDA_id']);
        $this->Cadre_id->setDbValue($row['Cadre_id']);
        $this->MDA_temp->setDbValue($row['MDA_temp']);
        $this->Asset_User_id->setDbValue($row['Asset_User_id']);
    }

    // Render list row values
    public function renderListRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Common render codes

        // Directoryid

        // Firstname

        // Middlename

        // Lastname

        // Email

        // Phone

        // Created_on

        // Updated_on

        // MDA_id

        // Cadre_id

        // MDA_temp

        // Asset_User_id

        // Directoryid
        $this->Directoryid->ViewValue = $this->Directoryid->CurrentValue;
        $this->Directoryid->ViewCustomAttributes = "";

        // Firstname
        $this->Firstname->ViewValue = $this->Firstname->CurrentValue;
        $this->Firstname->ViewCustomAttributes = "";

        // Middlename
        $this->Middlename->ViewValue = $this->Middlename->CurrentValue;
        $this->Middlename->ViewCustomAttributes = "";

        // Lastname
        $this->Lastname->ViewValue = $this->Lastname->CurrentValue;
        $this->Lastname->ViewCustomAttributes = "";

        // Email
        $this->_Email->ViewValue = $this->_Email->CurrentValue;
        $this->_Email->ViewCustomAttributes = "";

        // Phone
        $this->Phone->ViewValue = $this->Phone->CurrentValue;
        $this->Phone->ViewCustomAttributes = "";

        // Created_on
        $this->Created_on->ViewValue = $this->Created_on->CurrentValue;
        $this->Created_on->ViewValue = FormatDateTime($this->Created_on->ViewValue, 0);
        $this->Created_on->ViewCustomAttributes = "";

        // Updated_on
        $this->Updated_on->ViewValue = $this->Updated_on->CurrentValue;
        $this->Updated_on->ViewValue = FormatDateTime($this->Updated_on->ViewValue, 0);
        $this->Updated_on->ViewCustomAttributes = "";

        // MDA_id
        $this->MDA_id->ViewValue = $this->MDA_id->CurrentValue;
        $this->MDA_id->ViewValue = FormatNumber($this->MDA_id->ViewValue, 0, -2, -2, -2);
        $this->MDA_id->ViewCustomAttributes = "";

        // Cadre_id
        $this->Cadre_id->ViewValue = $this->Cadre_id->CurrentValue;
        $this->Cadre_id->ViewValue = FormatNumber($this->Cadre_id->ViewValue, 0, -2, -2, -2);
        $this->Cadre_id->ViewCustomAttributes = "";

        // MDA_temp
        $this->MDA_temp->ViewValue = $this->MDA_temp->CurrentValue;
        $this->MDA_temp->ViewCustomAttributes = "";

        // Asset_User_id
        $this->Asset_User_id->ViewValue = $this->Asset_User_id->CurrentValue;
        $this->Asset_User_id->ViewValue = FormatNumber($this->Asset_User_id->ViewValue, 0, -2, -2, -2);
        $this->Asset_User_id->ViewCustomAttributes = "";

        // Directoryid
        $this->Directoryid->LinkCustomAttributes = "";
        $this->Directoryid->HrefValue = "";
        $this->Directoryid->TooltipValue = "";

        // Firstname
        $this->Firstname->LinkCustomAttributes = "";
        $this->Firstname->HrefValue = "";
        $this->Firstname->TooltipValue = "";

        // Middlename
        $this->Middlename->LinkCustomAttributes = "";
        $this->Middlename->HrefValue = "";
        $this->Middlename->TooltipValue = "";

        // Lastname
        $this->Lastname->LinkCustomAttributes = "";
        $this->Lastname->HrefValue = "";
        $this->Lastname->TooltipValue = "";

        // Email
        $this->_Email->LinkCustomAttributes = "";
        $this->_Email->HrefValue = "";
        $this->_Email->TooltipValue = "";

        // Phone
        $this->Phone->LinkCustomAttributes = "";
        $this->Phone->HrefValue = "";
        $this->Phone->TooltipValue = "";

        // Created_on
        $this->Created_on->LinkCustomAttributes = "";
        $this->Created_on->HrefValue = "";
        $this->Created_on->TooltipValue = "";

        // Updated_on
        $this->Updated_on->LinkCustomAttributes = "";
        $this->Updated_on->HrefValue = "";
        $this->Updated_on->TooltipValue = "";

        // MDA_id
        $this->MDA_id->LinkCustomAttributes = "";
        $this->MDA_id->HrefValue = "";
        $this->MDA_id->TooltipValue = "";

        // Cadre_id
        $this->Cadre_id->LinkCustomAttributes = "";
        $this->Cadre_id->HrefValue = "";
        $this->Cadre_id->TooltipValue = "";

        // MDA_temp
        $this->MDA_temp->LinkCustomAttributes = "";
        $this->MDA_temp->HrefValue = "";
        $this->MDA_temp->TooltipValue = "";

        // Asset_User_id
        $this->Asset_User_id->LinkCustomAttributes = "";
        $this->Asset_User_id->HrefValue = "";
        $this->Asset_User_id->TooltipValue = "";

        // Call Row Rendered event
        $this->rowRendered();

        // Save data for Custom Template
        $this->Rows[] = $this->customTemplateFieldValues();
    }

    // Render edit row values
    public function renderEditRow()
    {
        global $Security, $CurrentLanguage, $Language;

        // Call Row Rendering event
        $this->rowRendering();

        // Directoryid
        $this->Directoryid->EditAttrs["class"] = "form-control";
        $this->Directoryid->EditCustomAttributes = "";
        $this->Directoryid->EditValue = $this->Directoryid->CurrentValue;
        $this->Directoryid->ViewCustomAttributes = "";

        // Firstname
        $this->Firstname->EditAttrs["class"] = "form-control";
        $this->Firstname->EditCustomAttributes = "";
        if (!$this->Firstname->Raw) {
            $this->Firstname->CurrentValue = HtmlDecode($this->Firstname->CurrentValue);
        }
        $this->Firstname->EditValue = $this->Firstname->CurrentValue;
        $this->Firstname->PlaceHolder = RemoveHtml($this->Firstname->caption());

        // Middlename
        $this->Middlename->EditAttrs["class"] = "form-control";
        $this->Middlename->EditCustomAttributes = "";
        if (!$this->Middlename->Raw) {
            $this->Middlename->CurrentValue = HtmlDecode($this->Middlename->CurrentValue);
        }
        $this->Middlename->EditValue = $this->Middlename->CurrentValue;
        $this->Middlename->PlaceHolder = RemoveHtml($this->Middlename->caption());

        // Lastname
        $this->Lastname->EditAttrs["class"] = "form-control";
        $this->Lastname->EditCustomAttributes = "";
        if (!$this->Lastname->Raw) {
            $this->Lastname->CurrentValue = HtmlDecode($this->Lastname->CurrentValue);
        }
        $this->Lastname->EditValue = $this->Lastname->CurrentValue;
        $this->Lastname->PlaceHolder = RemoveHtml($this->Lastname->caption());

        // Email
        $this->_Email->EditAttrs["class"] = "form-control";
        $this->_Email->EditCustomAttributes = "";
        if (!$this->_Email->Raw) {
            $this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
        }
        $this->_Email->EditValue = $this->_Email->CurrentValue;
        $this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

        // Phone
        $this->Phone->EditAttrs["class"] = "form-control";
        $this->Phone->EditCustomAttributes = "";
        if (!$this->Phone->Raw) {
            $this->Phone->CurrentValue = HtmlDecode($this->Phone->CurrentValue);
        }
        $this->Phone->EditValue = $this->Phone->CurrentValue;
        $this->Phone->PlaceHolder = RemoveHtml($this->Phone->caption());

        // Created_on
        $this->Created_on->EditAttrs["class"] = "form-control";
        $this->Created_on->EditCustomAttributes = "";
        $this->Created_on->EditValue = FormatDateTime($this->Created_on->CurrentValue, 8);
        $this->Created_on->PlaceHolder = RemoveHtml($this->Created_on->caption());

        // Updated_on
        $this->Updated_on->EditAttrs["class"] = "form-control";
        $this->Updated_on->EditCustomAttributes = "";
        $this->Updated_on->EditValue = FormatDateTime($this->Updated_on->CurrentValue, 8);
        $this->Updated_on->PlaceHolder = RemoveHtml($this->Updated_on->caption());

        // MDA_id
        $this->MDA_id->EditAttrs["class"] = "form-control";
        $this->MDA_id->EditCustomAttributes = "";
        $this->MDA_id->EditValue = $this->MDA_id->CurrentValue;
        $this->MDA_id->PlaceHolder = RemoveHtml($this->MDA_id->caption());

        // Cadre_id
        $this->Cadre_id->EditAttrs["class"] = "form-control";
        $this->Cadre_id->EditCustomAttributes = "";
        $this->Cadre_id->EditValue = $this->Cadre_id->CurrentValue;
        $this->Cadre_id->PlaceHolder = RemoveHtml($this->Cadre_id->caption());

        // MDA_temp
        $this->MDA_temp->EditAttrs["class"] = "form-control";
        $this->MDA_temp->EditCustomAttributes = "";
        $this->MDA_temp->PlaceHolder = RemoveHtml($this->MDA_temp->caption());

        // Asset_User_id
        $this->Asset_User_id->EditAttrs["class"] = "form-control";
        $this->Asset_User_id->EditCustomAttributes = "";
        $this->Asset_User_id->EditValue = $this->Asset_User_id->CurrentValue;
        $this->Asset_User_id->PlaceHolder = RemoveHtml($this->Asset_User_id->caption());

        // Call Row Rendered event
        $this->rowRendered();
    }

    // Aggregate list row values
    public function aggregateListRowValues()
    {
    }

    // Aggregate list row (for rendering)
    public function aggregateListRow()
    {
        // Call Row Rendered event
        $this->rowRendered();
    }

    // Export data in HTML/CSV/Word/Excel/Email/PDF format
    public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
    {
        if (!$recordset || !$doc) {
            return;
        }
        if (!$doc->ExportCustom) {
            // Write header
            $doc->exportTableHeader();
            if ($doc->Horizontal) { // Horizontal format, write header
                $doc->beginExportRow();
                if ($exportPageType == "view") {
                    $doc->exportCaption($this->Firstname);
                    $doc->exportCaption($this->Middlename);
                    $doc->exportCaption($this->Lastname);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Phone);
                    $doc->exportCaption($this->Cadre_id);
                    $doc->exportCaption($this->MDA_temp);
                } else {
                    $doc->exportCaption($this->Firstname);
                    $doc->exportCaption($this->Middlename);
                    $doc->exportCaption($this->Lastname);
                    $doc->exportCaption($this->_Email);
                    $doc->exportCaption($this->Phone);
                    $doc->exportCaption($this->Created_on);
                    $doc->exportCaption($this->Cadre_id);
                    $doc->exportCaption($this->MDA_temp);
                    $doc->exportCaption($this->Asset_User_id);
                }
                $doc->endExportRow();
            }
        }

        // Move to first record
        $recCnt = $startRec - 1;
        $stopRec = ($stopRec > 0) ? $stopRec : PHP_INT_MAX;
        while (!$recordset->EOF && $recCnt < $stopRec) {
            $row = $recordset->fields;
            $recCnt++;
            if ($recCnt >= $startRec) {
                $rowCnt = $recCnt - $startRec + 1;

                // Page break
                if ($this->ExportPageBreakCount > 0) {
                    if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0) {
                        $doc->exportPageBreak();
                    }
                }
                $this->loadListRowValues($row);

                // Render row
                $this->RowType = ROWTYPE_VIEW; // Render view
                $this->resetAttributes();
                $this->renderListRow();
                if (!$doc->ExportCustom) {
                    $doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
                    if ($exportPageType == "view") {
                        $doc->exportField($this->Firstname);
                        $doc->exportField($this->Middlename);
                        $doc->exportField($this->Lastname);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Phone);
                        $doc->exportField($this->Cadre_id);
                        $doc->exportField($this->MDA_temp);
                    } else {
                        $doc->exportField($this->Firstname);
                        $doc->exportField($this->Middlename);
                        $doc->exportField($this->Lastname);
                        $doc->exportField($this->_Email);
                        $doc->exportField($this->Phone);
                        $doc->exportField($this->Created_on);
                        $doc->exportField($this->Cadre_id);
                        $doc->exportField($this->MDA_temp);
                        $doc->exportField($this->Asset_User_id);
                    }
                    $doc->endExportRow($rowCnt);
                }
            }

            // Call Row Export server event
            if ($doc->ExportCustom) {
                $this->rowExport($row);
            }
            $recordset->moveNext();
        }
        if (!$doc->ExportCustom) {
            $doc->exportTableFooter();
        }
    }

    // Get file data
    public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0, $plugins = [])
    {
        // No binary fields
        return false;
    }

    // Table level events

    // Recordset Selecting event
    public function recordsetSelecting(&$filter)
    {
        // Enter your code here
    }

    // Recordset Selected event
    public function recordsetSelected(&$rs)
    {
        //Log("Recordset Selected");
    }

    // Recordset Search Validated event
    public function recordsetSearchValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Recordset Searching event
    public function recordsetSearching(&$filter)
    {
        // Enter your code here
    }

    // Row_Selecting event
    public function rowSelecting(&$filter)
    {
        // Enter your code here
    }

    // Row Selected event
    public function rowSelected(&$rs)
    {
        //Log("Row Selected");
    }

    // Row Inserting event
    public function rowInserting($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Inserted event
    public function rowInserted($rsold, &$rsnew)
    {
        //Log("Row Inserted");
    }

    // Row Updating event
    public function rowUpdating($rsold, &$rsnew)
    {
        // Enter your code here
        // To cancel, set return value to false
        return true;
    }

    // Row Updated event
    public function rowUpdated($rsold, &$rsnew)
    {
        //Log("Row Updated");
    }

    // Row Update Conflict event
    public function rowUpdateConflict($rsold, &$rsnew)
    {
        // Enter your code here
        // To ignore conflict, set return value to false
        return true;
    }

    // Grid Inserting event
    public function gridInserting()
    {
        // Enter your code here
        // To reject grid insert, set return value to false
        return true;
    }

    // Grid Inserted event
    public function gridInserted($rsnew)
    {
        //Log("Grid Inserted");
    }

    // Grid Updating event
    public function gridUpdating($rsold)
    {
        // Enter your code here
        // To reject grid update, set return value to false
        return true;
    }

    // Grid Updated event
    public function gridUpdated($rsold, $rsnew)
    {
        //Log("Grid Updated");
    }

    // Row Deleting event
    public function rowDeleting(&$rs)
    {
        // Enter your code here
        // To cancel, set return value to False
        return true;
    }

    // Row Deleted event
    public function rowDeleted(&$rs)
    {
        //Log("Row Deleted");
    }

    // Email Sending event
    public function emailSending($email, &$args)
    {
        //var_dump($email); var_dump($args); exit();
        return true;
    }

    // Lookup Selecting event
    public function lookupSelecting($fld, &$filter)
    {
        //var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
        // Enter your code here
    }

    // Row Rendering event
    public function rowRendering()
    {
        // Enter your code here
    }

    // Row Rendered event
    public function rowRendered()
    {
        // To view properties of field class, use:
        //var_dump($this-><FieldName>);
    }

    // User ID Filtering event
    public function userIdFiltering(&$filter)
    {
        // Enter your code here
    }
}
